
#include <avr/io.h>
#include "bits.h"

void clr_bit (unsigned char b)
{
  unsigned char bv;
  bv = 1 << (b&7);
  b &= ~7;
  switch (b) {
  case PB:PORTB &= ~bv;break;
  case PC:PORTC &= ~bv;break;
  case PD:PORTD &= ~bv;break;
  }
}


void set_bit (unsigned char b)
{
  unsigned char bv;
  bv = 1 << (b&7);
  b &= ~7;
  switch (b) {
  case PB:PORTB |= bv;break;
  case PC:PORTC |= bv;break;
  case PD:PORTD |= bv;break;
  }
}

void make_output (unsigned char b)
{
  unsigned char bv;
  bv = 1 << (b&7);
  b &= ~7;
  switch (b) {
  case PB:DDRB |= bv;break;
  case PC:DDRC |= bv;break;
  case PD:DDRD |= bv;break;
  }
}


void make_input (unsigned char b)
{
  unsigned char bv;
  bv = ~_BV (b&7);
  b &= ~7;
  switch (b) {
  case PB:DDRB &= bv;break;
  case PC:DDRC &= bv;break;
  case PD:DDRD &= bv;break;
  }
}

unsigned char get_input (unsigned char b)
{
  unsigned char iv = 0;
  switch (b & ~7) {
  case PB:iv = PINB;break;
  case PC:iv = PINC;break;
  case PD:iv = PIND;break;
  }
  iv >>= (b&7);
  return iv & 1;
}

void pinMode (unsigned char b, unsigned char mode)
{
  if (mode) make_output (b);
  else      make_input  (b);
}

void digitalWrite(unsigned char b, unsigned char v)
{
  if (v) set_bit (b);
  else   clr_bit (b);
}

unsigned char digitalRead (unsigned char b)
{
  return get_input (b);
}
